//
//  MCPDatabaseObjectContext.h
//  MCPersistence
//
//  Created by aj on Tue Dec 25 2001.
//  Copyright (c) 2001 __MyCompanyName__. All rights reserved.
//

#import <Foundation/Foundation.h>

#import "MCPObjectContext.h"


@class MCPDatabaseConnection;
@class MCPEntity;
@class MCUserDefaults;
@class MCAlertManager;
@class MCSourceListManager;

@interface MCPDatabaseObjectContext : MCPObjectContext {
	MCPDatabaseConnection		*_conn;

	MCUserDefaults*             _userDefaults;

	BOOL						_forceUpdatesForUnchangedRows;
	BOOL						_blockInstanceCacheRegistration;
	BOOL 						_retainsDatabaseConnection;

	MCAlertManager*             _alertManager;
}


- (id)initWithDatabaseConnection:(MCPDatabaseConnection *)connection;

- (void)setDatabaseConnection:(MCPDatabaseConnection *)connection;
- (MCPDatabaseConnection *)databaseConnection;

- (MCUserDefaults *)userDefaults;
- (void)setUserDefaults:(MCUserDefaults *)anUserDefaults;

/*
 Explictly retains the database connection. By default database connections are not retained. You can call this method even after a connection has been set. BUT ONLY CALL IT ONCE!
 
 */
- (void)setRetainsDatabaseConnection:(BOOL)flag;
- (BOOL)retainsDatabaseConnection;


/*
In the case of many-to-manies, a row may be marked for updates, but the attributes have not changes -- just the relationships. Set this to YES if you want to push those updates anyways.
*/
- (void)setForceUpdatesForObjectWithUnchangedAttributes:(BOOL)flag;
- (BOOL)forcesUpdatesForObjectsWithUnchangedAttributes;

- (void)rebuildQuickSearchTableWithUIDelegate:(id)deleg;

#pragma mark DatabaseConnectionConveniences
// throws expection if entity have more than one primary key
- (id)objectForEntity:(MCPEntity *)ent 
	wherePrimaryKeyValueIs:(id)aValue;

- (id)objectForEntityNamed:(NSString *)aName 
	wherePrimaryKeyValueIs:(id)aValue;

- (void)setupAndStartAlertManager;
- (MCAlertManager *)alertManager;
- (void)setAlertManager:(MCAlertManager *)anAlertManager;

- (NSString *)databaseName; // Convenience to get the document connection adapter's raw database name

@end

@interface NSObject(QuickSearchRebuilderUIDelegate)
- (void)objectContext:(MCPDatabaseObjectContext *)oc willBeginRebuildingWithTotalCount:(unsigned)total;
- (void)objectContext:(MCPDatabaseObjectContext *)oc didProcessObjectNumber:(unsigned)objNumber;
- (void)objectContextDidFinishRebuilding:(MCPDatabaseObjectContext *)oc;
@end
